const bcrypt = require('bcrypt');
const jwt = require('jsonwebtoken');
const config = require('../../configs/jwt.configs.js');
const { HTTP_SUCCESS_RESPONSE } = require("../utils/success");
const { HTTP400Error, HTTP404Error, catchAsync } = require("../utils/errors");

Admin = require('../models/admins.js');

module.exports = {
    create: catchAsync(async (req, res) => {
        const adminData = { firstName, lastName, email, phone, password, physicalAddress, mailingAddress } = req.body;
        let hashedPassword = bcrypt.hashSync(password, 8)
        let existAdmin = await Admin.find({ email: email});
        if(existAdmin.length < 1) {
            let admin = new Admin(adminData);
            admin.password = hashedPassword;
            return admin.save()
            .then(async function(admin) {
                await admin.setCreatedBy(admin._id); 
                await admin.setUpdatedBy(admin._id);
                await admin.save();
                return HTTP_SUCCESS_RESPONSE(res, { data: admin }, 'Admin User Successfully Created.' ); 
            }).catch(err => {
                throw new HTTP400Error(err.message);
            });    
            
        } else {
            throw new HTTP400Error('Eamil Already Exists');
        }
    }),

    login: catchAsync(async(req, res) => {
        const { email, password } = req.body;
        let admin = await Admin.findOne({ email: email });
        if(!admin ) throw new HTTP404Error('Email Does Not Exist.');
        admin = admin.toJSON(); 
        let passwordIsValid = await bcrypt.compareSync(password, admin.password);
        if (!passwordIsValid) throw new HTTP400Error('Password does not matched.');
        let token = jwt.sign({ _id: admin._id, email: admin.email }, config.secret, { expiresIn: '60m' });
        let refreshToken = jwt.sign({ _id: admin._id, email: admin.email }, config.secret, { expiresIn: '120m' });
        res.setHeader("Authorization", token);
        return HTTP_SUCCESS_RESPONSE(res, { token: token, refreshToken: refreshToken }, 'Auth Successful' );
    }),

    update: catchAsync(async(req, res) => {
        const adminData = { firstName, lastName, phone, email, physicalAddress, mailingAddress } = req.body;
        let id = req.params.id;
        let admin = await Admin.findById(id);
        if(!admin) throw new HTTP404Error('Admin not found');
        try {
            admin.firstName = firstName;
            admin.lastName = lastName;
            admin.phone = phone;
            admin.email = email;
            admin.physicalAddress = physicalAddress;
            admin.mailingAddress = mailingAddress;
            await admin.setUpdatedBy(req.admin._id); 
            await admin.setUpdatedAt();
            await admin.save();
            return HTTP_SUCCESS_RESPONSE(res, { data: admin }, 'Admin successfully updated' );
        } catch (err) {
            throw new HTTP400Error(err.message);
        }
    }),

    list: catchAsync(async(req, res) => {
        let adminList = await Admin.find({}).select({ firstName: 1, lastName: 1, phone: 1, email: 1, physicalAddress: 1, mailingAddress: 1 }).sort({created_at: -1});
        return HTTP_SUCCESS_RESPONSE(res, { data: adminList }, 'Admin list successfully retrieved.' );
    }),

    
    refresh: (req, res) => {
        let token = jwt.sign({ 
            _id: req.admin._id, 
            email: req.admin.email
            },
            config.secret, { expiresIn: '60m' }
        );

        let refreshToken = jwt.sign({ _id: req.admin._id, email: req.admin.email }, config.secret, { expiresIn: '120m' });
        res.setHeader("Authorization", token);
        return HTTP_SUCCESS_RESPONSE(res, { auth: true, token: token, token: token, refreshToken: refreshToken }, 'Refresh Request Successfull');
    },

    me: catchAsync(async(req, res) => {
        let id = req.admin._id;
        let admin = await Admin.findById(id).select({ firstName: 1, lastName: 1, phone: 1, email: 1, physicalAddress: 1, mailingAddress: 1 });
        if(!admin) throw new HTTP404Error('No admin found.');
        return HTTP_SUCCESS_RESPONSE(res, { data: admin }, 'Admin successfully retrieved');
    }),


    userDetails: catchAsync(async(req, res) => {
        let id = req.params.id;
        let admin = await Admin.findById(id).select({ firstName: 1, lastName: 1, phone: 1, email: 1, physicalAddress: 1, mailingAddress: 1 });
        if(!admin) throw new HTTP404Error('No admin found.');
        return HTTP_SUCCESS_RESPONSE(res, { data: admin }, 'Admin successfully retrieved');
    }),

    destroy: catchAsync(async(req, res) => {
        let id = req.params.id;
        let admin = await Admin.findOne({ _id: id });
        if(!admin) throw new HTTP404Error('No admin found.');
        await admin.delete();
        return HTTP_SUCCESS_RESPONSE(res, {}, 'Admin successfully deleted');
    })
}
