const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const DriversSchema = new Schema({
    firstName: {
        type: String,
        required: true
    },
    lastName: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true
    },

    phone: {
        type: String,
        required: false,
    },

    password: {
        type: String,
        required: false
    },

    profileImg: {
        type: String,
        required: false
    },
    
    isVerified: {
        type: Boolean,
        default: false
    },
    isNotify: {
        type: Boolean,
        default: true
    },

    physicalAddress: {
        street: { type: String, required: false },
        city: { type: String, required: false },
        state: { type: String, required: false },
        zip: { type: String, required: false },
    },

    mailingAddress: {
        street: { type: String, required: false },
        city: { type: String, required: false },
        state: { type: String, required: false },
        zip: { type: String, required: false },
    },

    accountType: {
        type: String,
        defaut: 'created',
        enum: {
            values: ['created', 'facebook', 'google'],
            message: '{VALUE} is not supported'
        },
    },

    addressCoordinates: {
        latitude: "",
        longitude:"",
        place_id: ""
    },

    token: {
        type: String,
        required: false
    },

    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

DriversSchema.methods.setCreatedBy = function(driver) {
    return this.createdBy = driver;
}

DriversSchema.methods.setUpdatedBy = function(driver) {
    return this.updatedBy = driver;
}

DriversSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Driver', DriversSchema);
