const sgMail = require("@sendgrid/mail");
sgMail.setApiKey(process.env.SENDGRID_API_KEY);
console.log(process.env.SENDGRID_API_KEY, process.env.EMAIL_SENDER);
const sendEmail = async (email, subject, text) => {
  const msg = {
    from: process.env.EMAIL_SENDER,
    to: email,
    subject,
    html: text,
  };

  let message = "";

  await sgMail.send(msg, function (err, result) {
    if (err) {
      console.log("Email Not Sent Error Occured", err.response.body.errors[0].message);
      message =  { status: 400, message: err.response.body.errors[0].message }
    } else {
      console.log("Email Sent Successfully");
      message =  { status: 200, message: 'Email Sent Successfully' }
    }
  });

  return message;
};

module.exports = sendEmail;