const { body } = require("express-validator");
const emailPasswordValidation = [
    body("password").exists().withMessage("Password is required."),
]

const updateProviderUserValidation = [
    body("companyName").exists().withMessage("Company name is required."),
    body("mainContactFirstName").exists().withMessage("Main contact first name is required."),
    body("mainContactLastName").exists().withMessage("Main contact last name is required."),
    body("certifiedMedicalExaminarFirstName").exists().withMessage("Certified medical examinar first name is required."),
    body("certifiedMedicalExaminarLastName").exists().withMessage("Certified medical examinar last name is required."),

    body("email").exists().withMessage("Email is required.").isEmail().withMessage("Email field must be valid."),
    body("phone").exists().withMessage("Phone is required."),

    body("physicalAddress").exists().withMessage("Physical address is required."),
    body("physicalAddress.street").exists().withMessage("Physical address street is required."),
    body("physicalAddress.city").exists().withMessage("Physical address city is required."),
    body("physicalAddress.state").exists().withMessage("Physical address state is required."),
    body("physicalAddress.zip").exists().withMessage("Physical address zip is required."),

    body("mailingAddress").exists().withMessage("Mailing address is required."),
    body("mailingAddress.street").exists().withMessage("Mailing address street is required."),
    body("mailingAddress.city").exists().withMessage("Mailing address city is required."),
    body("mailingAddress.state").exists().withMessage("Mailing address state is required."),
    body("mailingAddress.zip").exists().withMessage("Mailing address zip is required."),

    body("nrcmeNo").exists().withMessage("Nrcme no. is required."),
    body("nrcmeExpirationDate").exists().withMessage("Nrcme expiration date is required."),
    body("practitionerType").exists().withMessage("Practioner type is required.").isIn(['MD', 'PA', 'NP', 'DC']).withMessage('Practioner type must be MD or PA or NP or DC.'),
    body("appointmentType").exists().withMessage("Appointment type is required.").isIn(['walkin', 'appointment', 'both']).withMessage('Appointment type must be walkin or appointment or both.'),
    body("providerType").exists().withMessage("Provider type is required.").isIn(['preferred', 'oon']).withMessage('Provider type must be preferred or oon.'),
    body("testPrice").if((value, { req }) => req.body.providerType == 'oon').exists().withMessage("Test price is required for 'OON' provider type.")
];

const testPriceProviderUserValidation = [
    body("testPrice").exists().withMessage("Provider test price is required.").isInt().withMessage('Provider test price is numeric.'),
];

const passwordResetValidation = [
    body("password").exists().withMessage("Password is required."),
    body("confirmPassword").exists().withMessage("Confirm Password is required."),
]

const editPasswordProviderUserValidation = [
    body("currentPassword").exists().withMessage("Current password is required."),
    body("newPassword").exists().withMessage("New password is required."),
    body("confirmPassword").exists().withMessage("Confirm Password is required."),
]

const createProviderUserValidation = [...emailPasswordValidation, ...updateProviderUserValidation];

const loginProviderUserValidation = [...emailPasswordValidation]

module.exports = {
    createProviderUserValidation,
    loginProviderUserValidation,
    editPasswordProviderUserValidation,
    testPriceProviderUserValidation,
    updateProviderUserValidation,
    passwordResetValidation
}

