const { body } = require("express-validator");
const emailPasswordValidation = [
    body("password").exists().withMessage("Password is required."),
]

const updateDriverUserValidation = [
    body("firstName").exists().withMessage("First name is required."),
    body("lastName").exists().withMessage("Last name is required."),
    body("email").exists().withMessage("Email is required.").isEmail().withMessage("Email field must be valid."),
    body("phone").exists().withMessage("Phone is required."),

    body("physicalAddress").exists().withMessage("Physical address is required."),
    body("physicalAddress.street").exists().withMessage("Physical address street is required."),
    body("physicalAddress.city").exists().withMessage("Physical address city is required."),
    body("physicalAddress.state").exists().withMessage("Physical address state is required."),
    body("physicalAddress.zip").exists().withMessage("Physical address zip is required."),

    body("mailingAddress").exists().withMessage("Mailing address is required."),
    body("mailingAddress.street").exists().withMessage("Mailing address street is required."),
    body("mailingAddress.city").exists().withMessage("Mailing address city is required."),
    body("mailingAddress.state").exists().withMessage("Mailing address state is required."),
    body("mailingAddress.zip").exists().withMessage("Mailing address zip is required."),
];

const passwordResetValidation = [
    body("password").exists().withMessage("Password is required."),
    body("confirmPassword").exists().withMessage("Confirm Password is required."),
]

const createDriverUserValidation = [...emailPasswordValidation, ...updateDriverUserValidation];

const loginDriverUserValidation = [...emailPasswordValidation]

module.exports = {
    createDriverUserValidation,
    loginDriverUserValidation,
    updateDriverUserValidation,
    passwordResetValidation
}

