const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const ScheduleSchema = new Schema({
    provider: {
        type: Schema.Types.ObjectId,
        ref: 'Provider',
        required: true
    },
    date: {
        type: String,
        required: true
    },
    day: {
        type: String,
        required: true
    },
    startTime: {
        type: String,
        required: true
    },

    endTime: {
        type: String,
        required: false,
    },
    
    status: {
        type: Boolean,
        default: false
    },

    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

ScheduleSchema.methods.setCreatedBy = function(provider) {
    return this.createdBy = provider;
}

ScheduleSchema.methods.setUpdatedBy = function(provider) {
    return this.updatedBy = provider;
}

ScheduleSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Schedule', ScheduleSchema);
