const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const PaymentsSchema = new Schema({
    provider: {
        type: Schema.Types.ObjectId,
        ref: 'Provider',
        required: true
    },

    driver: {
        type: Schema.Types.ObjectId,
        ref: 'Driver',
        required: true
    },

    billingAddress: {
        street: { type: String, required: true },
        city: { type: String, required: true },
        state: { type: String, required: true },
        zip: { type: String, required: true },
    },

    amount: {
        type: Number,
        required: true,
    },

    paymentMethod: {
        type: String,
        required: true
    },

    stripeId: {
        type: String,
        required: false
    },
    
    uuid: {
        type: String,
        required: true
    },

    createdAt: {
        type: Date,
        default: Date.now
    },
    updatedAt: {
        type: Date,
        default: Date.now
    },
    createdBy: { type : Schema.Types.ObjectId, required: false },
    updatedBy: { type : Schema.Types.ObjectId, required: false }
});

PaymentsSchema.methods.setCreatedBy = function(driver) {
    return this.createdBy = driver;
}

PaymentsSchema.methods.setUpdatedBy = function(driver) {
    return this.updatedBy = driver;
}

PaymentsSchema.methods.setUpdatedAt = function() {
    return this.updatedAt = new Date();
}


module.exports = mongoose.model('Payment', PaymentsSchema);
